"""
this scripts unxor some big endian bytes
"""
ADDRS = 0x00000000  # start
ADDRE = 0x00000000  # end (exclusive)

KEY = 0x39e3c19bbb935373
BIG_ENDIAN = False

mem = currentProgram.getMemory()

size = ADDRE - ADDRS
if size <= 0:
    raise Exception("invalid range")

data = mem.getBytes(toAddr(ADDRS), size)
if data is None:
    raise Exception("memory read failed")

out = bytearray(size)
for i, b in enumerate(data):
    idx = 7 - (i & 7) if BIG_ENDIAN else (i & 7)
    out[i] = b ^ ((KEY >> (idx * 8)) & 0xff)

with open("/tmp/dec.bin", "wb") as f:
    f.write(out)
